<?php
// RVT/status.php
include 'config.php';
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

$client = isset($_GET['client']) ? $_GET['client'] : '';
$category = isset($_GET['category']) ? $_GET['category'] : '';

$response = ['status' => 0, 'visa_center' => 'islamabad'];

if ($client && $category) {
    $conn = getDbConnection();
    
    // Check for expiry first
    $check = $conn->prepare("SELECT id, allow_once_expires FROM rvt_panels WHERE client_slug = ? AND category_slug = ?");
    $check->bind_param("ss", $client, $category);
    $check->execute();
    $res = $check->get_result();
    
    if ($res->num_rows > 0) {
        $row = $res->fetch_assoc();
        if ($row['allow_once_expires']) {
            $now = new DateTime();
            $exp = new DateTime($row['allow_once_expires']);
            if ($now >= $exp) {
                $conn->query("UPDATE rvt_panels SET status = 0, allow_once_expires = NULL WHERE id = " . $row['id']);
            }
        }
    }

    // Fetch current status
    $stmt = $conn->prepare("SELECT status, visa_center, delayed_enabled, delayed_ms FROM rvt_panels WHERE client_slug = ? AND category_slug = ?");
    $stmt->bind_param("ss", $client, $category);
    $stmt->execute();
    $data = $stmt->get_result()->fetch_assoc();
    
    if ($data) {
        $response['status'] = (int)$data['status'];
        $response['visa_center'] = $data['visa_center'];
        
        // Handle Delay
        if ($data['delayed_enabled'] && $data['delayed_ms'] > 0) {
            usleep($data['delayed_ms'] * 1000);
        }
    }
    
    $conn->close();
}

echo json_encode($response);
?>
