<?php
// bls.txyber.com/publictoolsbls_blocked/vt-cp/action.php
include 'config.php';

header('Content-Type: application/json');

$response = ['success' => false, 'message' => 'Invalid request'];

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action'])) {
    $action = $_POST['action'];
    $conn = getDbConnection();

    $stmt = null; // Initialize $stmt

    switch ($action) {
        case 'allow':
            // Set allowed and clear any delayed mode
            $stmt = $conn->prepare("UPDATE " . DB_TABLE . " SET status = 1, delayed_enabled = 0, allow_once_expires = NULL WHERE id = 1");
            break;
        case 'allow_once': // Set allowed briefly and clear delayed mode
            // We'll set status=1, clear delayed_enabled and set allow_once_expires later after reading duration
            $stmt = $conn->prepare("UPDATE " . DB_TABLE . " SET status = 1, delayed_enabled = 0 WHERE id = 1");
            break;
        case 'delayed_allow':
            // Enable delayed mode and set status to allowed
            $stmt = $conn->prepare("UPDATE " . DB_TABLE . " SET status = 1, delayed_enabled = 1 WHERE id = 1");
            break;
        case 'disable_delayed':
            $stmt = $conn->prepare("UPDATE " . DB_TABLE . " SET delayed_enabled = 0 WHERE id = 1");
            break;
        case 'configure':
            // configure delayed_ms and allow_once_duration_ms (expect numeric ms values)
            $delayed_ms = isset($_POST['delayed_ms']) ? (int)$_POST['delayed_ms'] : 1300;
            $allow_once_duration_ms = isset($_POST['allow_once_duration_ms']) ? (int)$_POST['allow_once_duration_ms'] : 5000;
            $stmt = $conn->prepare("UPDATE " . DB_TABLE . " SET delayed_ms = ?, allow_once_duration_ms = ? WHERE id = 1");
            if ($stmt) {
                $stmt->bind_param('ii', $delayed_ms, $allow_once_duration_ms);
            }
            break;
        case 'fetch':
            // return current settings without updating
            $response = ['success' => true, 'message' => 'fetched'];
            $q = $conn->prepare("SELECT status, delayed_enabled, delayed_ms, allow_once_duration_ms, allow_once_expires, visa_center FROM " . DB_TABLE . " WHERE id = 1");
            if ($q) {
                $q->execute();
                $q->bind_result($s_status, $s_delayed_enabled, $s_delayed_ms, $s_allow_once_duration_ms, $s_allow_once_expires, $s_visa_center);
                $q->fetch();
                $q->close();
                $response['newStatus'] = (int)$s_status;
                $response['delayed_enabled'] = (int)$s_delayed_enabled;
                $response['delayed_ms'] = (int)$s_delayed_ms;
                $response['allow_once_duration_ms'] = (int)$s_allow_once_duration_ms;
                $response['allow_once_expires'] = $s_allow_once_expires;
                $response['visa_center'] = $s_visa_center ? strtolower($s_visa_center) : 'islamabad';
            }
            echo json_encode($response);
            $conn->close();
            exit;
        case 'stop':
            // Stop immediately and clear delayed mode
            $stmt = $conn->prepare("UPDATE " . DB_TABLE . " SET status = 0, delayed_enabled = 0, allow_once_expires = NULL WHERE id = 1");
            break;
        case 'set_center':
            // Set visa center (karachi, lahore, islamabad)
            $center = isset($_POST['center']) ? strtolower(trim($_POST['center'])) : 'islamabad';
            $allowed_centers = ['karachi', 'lahore', 'islamabad'];
            if (!in_array($center, $allowed_centers)) {
                $center = 'islamabad';
            }
            $stmt = $conn->prepare("UPDATE " . DB_TABLE . " SET visa_center = ? WHERE id = 1");
            if ($stmt) {
                $stmt->bind_param('s', $center);
            }
            break;
        default:
            // Invalid action, default response remains
            break;
    }

    if ($stmt) { // Check if a statement was prepared
        if ($stmt->execute()) {
            // If action was allow_once, set expiry server-side based on allow_once_duration_ms
            if ($action === 'allow_once') {
                // read duration from DB and write allow_once_expires = NOW() + duration
                $q = $conn->prepare("SELECT allow_once_duration_ms FROM " . DB_TABLE . " WHERE id = 1");
                if ($q) {
                    $q->execute();
                    $q->bind_result($allow_once_duration_ms);
                    $q->fetch();
                    $q->close();
                    $expires_ts = time() + (int)($allow_once_duration_ms / 1000);
                    $expires_dt = date('Y-m-d H:i:s', $expires_ts);
                    $u = $conn->prepare("UPDATE " . DB_TABLE . " SET allow_once_expires = ? WHERE id = 1");
                    if ($u) {
                        $u->bind_param('s', $expires_dt);
                        $u->execute();
                        $u->close();
                    }
                }
            }

            // Fetch the new status to return in the response
            $current_status = 0;
            $fetch_stmt = $conn->prepare("SELECT status, delayed_enabled, delayed_ms, allow_once_duration_ms, allow_once_expires, visa_center FROM " . DB_TABLE . " WHERE id = 1");
            if ($fetch_stmt) {
                $fetch_stmt->execute();
                $fetch_stmt->bind_result($current_status, $delayed_enabled, $delayed_ms, $allow_once_duration_ms, $allow_once_expires, $visa_center);
                $fetch_stmt->fetch();
                $fetch_stmt->close();
            }

            $response['success'] = true;
            $response['message'] = 'Status updated successfully.';
            $response['newStatus'] = (int)$current_status;
            $response['delayed_enabled'] = isset($delayed_enabled) ? (int)$delayed_enabled : 0;
            $response['delayed_ms'] = isset($delayed_ms) ? (int)$delayed_ms : 1300;
            $response['allow_once_duration_ms'] = isset($allow_once_duration_ms) ? (int)$allow_once_duration_ms : 5000;
            $response['allow_once_expires'] = isset($allow_once_expires) ? $allow_once_expires : null;
            $response['visa_center'] = isset($visa_center) ? strtolower($visa_center) : 'islamabad';
        } else {
            $response['message'] = 'Failed to update status: ' . $stmt->error;
        }
        $stmt->close();
    }
    $conn->close();
}

echo json_encode($response);
?>
