<?php
// bls.txyber.com/publictoolsbls_blocked/vt-cp/status.php
include 'config.php';

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *'); // Allow all origins for Tampermonkey script
// Default values
$status = 0;
$delayed_enabled = 0;
$delayed_ms = 1300;
$visa_center = 'islamabad';

try {
    $conn = getDbConnection();
    $stmt = $conn->prepare("SELECT status, delayed_enabled, delayed_ms, allow_once_duration_ms, allow_once_expires, visa_center FROM " . DB_TABLE . " WHERE id = 1");
    if ($stmt) {
        $stmt->execute();
        $stmt->bind_result($status_from_db, $delayed_enabled_db, $delayed_ms_db, $allow_once_duration_ms_db, $allow_once_expires, $visa_center_db);
        $stmt->fetch();
        $stmt->close();

        if (isset($status_from_db)) {
            $status = (int)$status_from_db;
        }
        $delayed_enabled = isset($delayed_enabled_db) ? (int)$delayed_enabled_db : 0;
        $delayed_ms = isset($delayed_ms_db) ? (int)$delayed_ms_db : 1300;
        $allow_once_duration_ms = isset($allow_once_duration_ms_db) ? (int)$allow_once_duration_ms_db : 5000;
        $visa_center = isset($visa_center_db) ? strtolower($visa_center_db) : 'islamabad';
    }

    // Auto-expire allow_once on server side if expiry is set and has passed
    if (!empty($allow_once_expires)) {
        $now = new DateTime('now');
        $expires = new DateTime($allow_once_expires);
        if ($now >= $expires) {
            // expire allow_once: set status to 0 and clear allow_once_expires
            $u = $conn->prepare("UPDATE " . DB_TABLE . " SET status = 0, allow_once_expires = NULL WHERE id = 1");
            if ($u) {
                $u->execute();
                $u->close();
                $status = 0;
            }
        }
    }

    $conn->close();
} catch (Exception $e) {
    error_log("BLS Status API Error: " . $e->getMessage());
}

// If delayed mode is enabled, sleep before responding (milliseconds)
if ($delayed_enabled && $delayed_ms > 0) {
    // usleep takes microseconds
    usleep($delayed_ms * 1000);
}

// Return status and visa_center for Tampermonkey script
echo json_encode(['status' => $status, 'visa_center' => $visa_center]);
?>
