<?php
// RVT/api.php
include 'config.php';
header('Content-Type: application/json');

$response = ['success' => false, 'message' => 'Invalid request'];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $client = isset($_POST['client']) ? $_POST['client'] : '';
    $category = isset($_POST['category']) ? $_POST['category'] : '';
    $action = isset($_POST['action']) ? $_POST['action'] : '';

    if ($client && $category && $action) {
        $conn = getDbConnection();
        
        // Verify panel exists
        $check = $conn->prepare("SELECT id FROM rvt_panels WHERE client_slug = ? AND category_slug = ?");
        $check->bind_param("ss", $client, $category);
        $check->execute();
        $res = $check->get_result();
        
        if ($res->num_rows > 0) {
            $row = $res->fetch_assoc();
            $id = $row['id'];
            $stmt = null;

            switch ($action) {
                case 'allow':
                    $stmt = $conn->prepare("UPDATE rvt_panels SET status = 1, delayed_enabled = 0, allow_once_expires = NULL WHERE id = ?");
                    $stmt->bind_param("i", $id);
                    break;
                case 'stop':
                    $stmt = $conn->prepare("UPDATE rvt_panels SET status = 0, delayed_enabled = 0, allow_once_expires = NULL WHERE id = ?");
                    $stmt->bind_param("i", $id);
                    break;
                case 'allow_once':
                    // Get duration first
                    $dStmt = $conn->prepare("SELECT allow_once_duration_ms FROM rvt_panels WHERE id = ?");
                    $dStmt->bind_param("i", $id);
                    $dStmt->execute();
                    $dRes = $dStmt->get_result()->fetch_assoc();
                    $duration = $dRes['allow_once_duration_ms'];
                    
                    $expires = date('Y-m-d H:i:s', time() + ($duration/1000));
                    
                    $stmt = $conn->prepare("UPDATE rvt_panels SET status = 1, delayed_enabled = 0, allow_once_expires = ? WHERE id = ?");
                    $stmt->bind_param("si", $expires, $id);
                    $response['allow_once_duration_ms'] = $duration;
                    break;
                case 'delayed_allow':
                    $stmt = $conn->prepare("UPDATE rvt_panels SET status = 1, delayed_enabled = 1 WHERE id = ?");
                    $stmt->bind_param("i", $id);
                    break;
                case 'set_center':
                    $center = isset($_POST['center']) ? $_POST['center'] : 'islamabad';
                    $stmt = $conn->prepare("UPDATE rvt_panels SET visa_center = ? WHERE id = ?");
                    $stmt->bind_param("si", $center, $id);
                    break;
                case 'configure':
                    $ms = isset($_POST['delayed_ms']) ? (int)$_POST['delayed_ms'] : 1300;
                    $stmt = $conn->prepare("UPDATE rvt_panels SET delayed_ms = ? WHERE id = ?");
                    $stmt->bind_param("ii", $ms, $id);
                    break;
            }

            if ($stmt && $stmt->execute()) {
                // Fetch updated state
                $fStmt = $conn->prepare("SELECT status, visa_center, delayed_ms FROM rvt_panels WHERE id = ?");
                $fStmt->bind_param("i", $id);
                $fStmt->execute();
                $newData = $fStmt->get_result()->fetch_assoc();
                
                $response['success'] = true;
                $response['message'] = "Action '$action' completed.";
                $response['newStatus'] = (int)$newData['status'];
                $response['visa_center'] = $newData['visa_center'];
                $response['delayed_ms'] = $newData['delayed_ms'];
            } else {
                $response['message'] = "Database update failed.";
            }
        } else {
            $response['message'] = "Panel not found.";
        }
        $conn->close();
    }
}

echo json_encode($response);
?>
