<?php
// RVT/admin/index.php
session_start();
include '../config.php';

$conn = getDbConnection();
$message = '';
$error = '';

// --- LOGIN LOGIC ---
if (isset($_POST['login'])) {
    $username = trim($_POST['username']);
    $password = $_POST['password'];

    $stmt = $conn->prepare("SELECT id, password_hash FROM rvt_admin WHERE username = ?");
    if ($stmt) {
        $stmt->bind_param("s", $username);
        $stmt->execute();
        $res = $stmt->get_result();
        if ($row = $res->fetch_assoc()) {
            if (password_verify($password, $row['password_hash'])) {
                $_SESSION['admin_logged_in'] = true;
                $_SESSION['admin_id'] = $row['id'];
                $_SESSION['admin_user'] = $username;
                header("Location: " . $_SERVER['PHP_SELF']);
                exit;
            }
        }
        $stmt->close();
    }
    $error = "Invalid username or password";
}

// --- LOGOUT LOGIC ---
if (isset($_GET['logout'])) {
    session_destroy();
    header("Location: " . $_SERVER['PHP_SELF']);
    exit;
}

// --- REQUIRE LOGIN ---
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>RVT Admin Login</title>
    <style>
        body { font-family: 'Segoe UI', sans-serif; background: #1a202c; display: flex; justify-content: center; align-items: center; height: 100vh; margin: 0; color: #e2e8f0; }
        .login-box { background: #2d3748; padding: 40px; border-radius: 12px; box-shadow: 0 4px 20px rgba(0,0,0,0.3); width: 100%; max-width: 320px; }
        h2 { text-align: center; margin-top: 0; color: #fff; margin-bottom: 20px; }
        input { width: 100%; padding: 12px; margin-bottom: 15px; border: 1px solid #4a5568; background: #4a5568; color: white; border-radius: 6px; box-sizing: border-box; font-size: 16px; }
        input::placeholder { color: #a0aec0; }
        input:focus { border-color: #63b3ed; outline: none; }
        button { width: 100%; padding: 12px; background: #3182ce; color: white; border: none; border-radius: 6px; cursor: pointer; font-size: 16px; font-weight: bold; }
        button:hover { background: #2b6cb0; }
        .error { color: #fc8181; text-align: center; margin-bottom: 15px; font-size: 0.9em; background: rgba(252, 129, 129, 0.1); padding: 10px; border-radius: 4px; border: 1px solid #fc8181; }
    </style>
</head>
<body>
    <div class="login-box">
        <h2>Admin Login</h2>
        <?php if ($error) echo "<div class='error'>$error</div>"; ?>
        <form method="POST">
            <input type="text" name="username" placeholder="Username" required autofocus>
            <input type="password" name="password" placeholder="Password" required>
            <button type="submit" name="login">Sign In</button>
        </form>
    </div>
</body>
</html>
<?php
    $conn->close();
    exit;
}

// --- DOWNLOAD SCRIPT LOGIC ---
if (isset($_GET['action']) && $_GET['action'] === 'download_script') {
    $client = $_GET['client'];
    $category = $_GET['category'];
    
    // Determine script type based on category name (default to work if not study)
    $scriptType = (strpos(strtolower($category), 'study') !== false) ? 'study' : 'work';
    $templatePath = "../templates/{$scriptType}.js";
    
    if (file_exists($templatePath)) {
        $content = file_get_contents($templatePath);
        
        // Construct Status URL
        $protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http";
        $host = $_SERVER['HTTP_HOST'];
        $path = dirname(dirname($_SERVER['PHP_SELF'])); // Go up one level from /admin/index.php to /RVT/
        $path = rtrim($path, '/');
        $statusUrl = "$protocol://$host$path/status.php?client=" . urlencode($client) . "&category=" . urlencode($category);
        
        // Replace URL in script
        $content = preg_replace(
            '/const REMOTE_STATUS_API_URL = ".*";/', 
            'const REMOTE_STATUS_API_URL = "' . $statusUrl . '";', 
            $content
        );
        
        // Force Download
        header('Content-Type: application/javascript');
        header('Content-Disposition: attachment; filename="Visatype_' . ucfirst($client) . '_' . ucfirst($category) . '.js"');
        echo $content;
        exit;
    } else {
        $error = "Template file not found for type: $scriptType";
    }
}

// --- DASHBOARD ACTIONS ---

// 1. Create Panel
if (isset($_POST['action']) && $_POST['action'] === 'create') {
    $client = strtolower(trim($_POST['client']));
    
    // Handle Category Dropdown Logic
    $catType = $_POST['category_type'];
    $catCustom = strtolower(trim($_POST['category_custom']));
    
    if ($catType === 'custom') {
        $category = $catCustom;
    } else {
        $category = $catType;
    }
    
    if ($client && $category) {
        $stmt = $conn->prepare("INSERT INTO rvt_panels (client_slug, category_slug) VALUES (?, ?)");
        $stmt->bind_param("ss", $client, $category);
        if ($stmt->execute()) {
            $message = "Panel created successfully!";
        } else {
            $error = "Error: Panel likely already exists.";
        }
        $stmt->close();
    } else {
        $error = "Client and Category are required.";
    }
} 
// 2. Delete Panel
elseif (isset($_POST['action']) && $_POST['action'] === 'delete') {
    $id = (int)$_POST['id'];
    $stmt = $conn->prepare("DELETE FROM rvt_panels WHERE id = ?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $stmt->close();
    $message = "Panel deleted.";
}
// 3. Change Admin Credentials
elseif (isset($_POST['action']) && $_POST['action'] === 'change_creds') {
    $new_user = trim($_POST['new_username']);
    $new_pass = $_POST['new_password'];
    
    if ($new_user && $new_pass) {
        $hash = password_hash($new_pass, PASSWORD_DEFAULT);
        $admin_id = $_SESSION['admin_id'];
        
        $stmt = $conn->prepare("UPDATE rvt_admin SET username = ?, password_hash = ? WHERE id = ?");
        $stmt->bind_param("ssi", $new_user, $hash, $admin_id);
        
        if ($stmt->execute()) {
            $message = "Admin credentials updated successfully.";
            $_SESSION['admin_user'] = $new_user; // Update session
        } else {
            $error = "Failed to update credentials.";
        }
        $stmt->close();
    } else {
        $error = "Username and Password cannot be empty.";
    }
}

// Fetch all panels
$panels = [];
$result = $conn->query("SELECT * FROM rvt_panels ORDER BY created_at DESC");
if ($result) {
    while ($row = $result->fetch_assoc()) {
        $panels[] = $row;
    }
}
$conn->close();

// Base URL for links
$baseUrl = "https://" . $_SERVER['HTTP_HOST'] . dirname(dirname($_SERVER['PHP_SELF']));
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>RVT Admin Dashboard</title>
    <style>
        /* Dark Mode Global */
        body { font-family: 'Segoe UI', sans-serif; background: #1a202c; padding: 20px; color: #e2e8f0; }
        .container { max-width: 1000px; margin: 0 auto; }
        
        /* Header */
        .header { display: flex; justify-content: space-between; align-items: center; margin-bottom: 25px; background: #2d3748; padding: 20px 25px; border-radius: 10px; box-shadow: 0 4px 6px rgba(0,0,0,0.1); }
        h1 { margin: 0; font-size: 1.6em; color: #fff; font-weight: 700; }
        .user-info { display: flex; align-items: center; gap: 20px; }
        .logout-btn { color: #fc8181; text-decoration: none; font-weight: 600; border: 1px solid #fc8181; padding: 6px 15px; border-radius: 6px; transition: all 0.2s; font-size: 0.9em; }
        .logout-btn:hover { background: #c53030; color: white; border-color: #c53030; }

        /* Cards */
        .card { background: #2d3748; padding: 25px; border-radius: 10px; box-shadow: 0 4px 6px rgba(0,0,0,0.1); margin-bottom: 25px; }
        h3 { margin-top: 0; border-bottom: 2px solid #4a5568; padding-bottom: 15px; color: #e2e8f0; font-size: 1.2em; }

        /* Forms */
        .form-group { margin-bottom: 15px; }
        label { display: block; margin-bottom: 8px; font-weight: 600; font-size: 0.9em; color: #cbd5e0; }
        
        input[type="text"], input[type="password"], select { 
            width: 100%; padding: 12px; box-sizing: border-box; 
            border: 1px solid #4a5568; background: #4a5568; color: white; 
            border-radius: 6px; font-size: 1em; transition: border-color 0.2s; 
        }
        input::placeholder { color: #a0aec0; }
        input:focus, select:focus { border-color: #63b3ed; outline: none; }
        
        button.primary-btn { padding: 12px 24px; background: #3182ce; color: white; border: none; border-radius: 6px; cursor: pointer; font-weight: 600; font-size: 1em; transition: background 0.2s; }
        button.primary-btn:hover { background: #2b6cb0; }
        
        button.secondary-btn { padding: 10px 20px; background: #4a5568; color: white; border: none; border-radius: 6px; cursor: pointer; font-weight: 600; }
        button.secondary-btn:hover { background: #2d3748; }

        /* Table */
        table { width: 100%; border-collapse: separate; border-spacing: 0; }
        th, td { padding: 15px; text-align: left; border-bottom: 1px solid #4a5568; }
        th { background-color: #2d3748; color: #a0aec0; font-weight: 600; text-transform: uppercase; font-size: 0.85em; letter-spacing: 0.05em; border-bottom: 2px solid #4a5568; }
        tr:last-child td { border-bottom: none; }
        
        .link-box { background: #4a5568; padding: 6px 12px; font-family: 'Consolas', monospace; font-size: 0.85em; border-radius: 4px; display: inline-block; color: #e2e8f0; }
        .link-box a { text-decoration: none; color: #63b3ed; font-weight: 600; }
        .link-box a:hover { text-decoration: underline; }

        .action-btn { padding: 6px 12px; border-radius: 4px; text-decoration: none; font-size: 0.85em; font-weight: 600; display: inline-block; cursor: pointer; border: none; }
        .delete-btn { background: rgba(252, 129, 129, 0.1); color: #fc8181; border: 1px solid #fc8181; }
        .delete-btn:hover { background: #c53030; color: white; border-color: #c53030; }
        .download-btn { background: rgba(99, 179, 237, 0.1); color: #63b3ed; border: 1px solid #63b3ed; margin-right: 5px; }
        .download-btn:hover { background: #3182ce; color: white; border-color: #3182ce; }

        /* Alerts */
        .alert { padding: 15px; border-radius: 8px; margin-bottom: 25px; font-weight: 500; }
        .alert.success { background: rgba(72, 187, 120, 0.2); color: #68d391; border: 1px solid #48bb78; }
        .alert.error { background: rgba(245, 101, 101, 0.2); color: #fc8181; border: 1px solid #f56565; }

        /* Modal for Change Password */
        details { margin-top: 10px; }
        summary { cursor: pointer; color: #63b3ed; font-weight: 600; outline: none; padding: 5px 0; }
        summary:hover { text-decoration: underline; }
    </style>
    <script>
        function toggleCustomCategory() {
            var select = document.getElementById('categoryType');
            var customInput = document.getElementById('categoryCustom');
            if (select.value === 'custom') {
                customInput.style.display = 'block';
                customInput.required = true;
            } else {
                customInput.style.display = 'none';
                customInput.required = false;
            }
        }
    </script>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>RVT Admin Dashboard</h1>
            <div class="user-info">
                <span>Welcome, <b><?php echo htmlspecialchars($_SESSION['admin_user']); ?></b></span>
                <a href="?logout=1" class="logout-btn">Logout</a>
            </div>
        </div>
        
        <?php if ($message): ?>
            <div class="alert success"><?php echo htmlspecialchars($message); ?></div>
        <?php endif; ?>
        <?php if ($error): ?>
            <div class="alert error"><?php echo htmlspecialchars($error); ?></div>
        <?php endif; ?>

        <!-- Create Panel Section -->
        <div class="card">
            <h3>Create New Panel</h3>
            <form method="POST" style="display: flex; gap: 20px; align-items: flex-start; flex-wrap: wrap;">
                <input type="hidden" name="action" value="create">
                <div style="flex: 1; min-width: 200px;">
                    <label>Client Name</label>
                    <input type="text" name="client" required placeholder="e.g. bilal">
                </div>
                <div style="flex: 1; min-width: 200px;">
                    <label>Category</label>
                    <select name="category_type" id="categoryType" onchange="toggleCustomCategory()" style="margin-bottom: 10px;">
                        <option value="study">Study</option>
                        <option value="work">Work</option>
                        <option value="custom">Custom</option>
                    </select>
                    <input type="text" name="category_custom" id="categoryCustom" style="display:none;" placeholder="Enter custom category">
                </div>
                <div style="align-self: flex-end; padding-bottom: 2px;">
                    <button type="submit" class="primary-btn">Create Panel</button>
                </div>
            </form>
        </div>

        <!-- Panels List -->
        <div class="card">
            <h3>Active Panels</h3>
            <div style="overflow-x: auto;">
                <table>
                    <thead>
                        <tr>
                            <th>Client</th>
                            <th>Category</th>
                            <th>Access Link</th>
                            <th>Script</th>
                            <th>Created</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($panels as $panel): ?>
                            <?php 
                                $link = $baseUrl . "/panel.php?client=" . urlencode($panel['client_slug']) . "&category=" . urlencode($panel['category_slug']);
                                $downloadLink = "?action=download_script&client=" . urlencode($panel['client_slug']) . "&category=" . urlencode($panel['category_slug']);
                            ?>
                            <tr>
                                <td><b><?php echo htmlspecialchars($panel['client_slug']); ?></b></td>
                                <td><span style="background:#4a5568; padding: 2px 8px; border-radius: 12px; font-size: 0.85em; color: #e2e8f0;"><?php echo htmlspecialchars($panel['category_slug']); ?></span></td>
                                <td><div class="link-box"><a href="<?php echo $link; ?>" target="_blank">Open Panel</a></div></td>
                                <td>
                                    <a href="<?php echo $downloadLink; ?>" class="action-btn download-btn" title="Download customized script">Download JS</a>
                                </td>
                                <td style="font-size: 0.85em; color: #a0aec0;"><?php echo date('M j, Y', strtotime($panel['created_at'])); ?></td>
                                <td>
                                    <form method="POST" onsubmit="return confirm('Are you sure you want to delete this panel?');" style="display:inline;">
                                        <input type="hidden" name="action" value="delete">
                                        <input type="hidden" name="id" value="<?php echo $panel['id']; ?>">
                                        <button type="submit" class="action-btn delete-btn">Delete</button>
                                    </form>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                        <?php if (empty($panels)): ?>
                            <tr>
                                <td colspan="6" style="text-align: center; color: #a0aec0; padding: 30px;">No panels created yet.</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>

        <!-- Change Credentials -->
        <div class="card">
            <details>
                <summary>Change Admin Credentials</summary>
                <form method="POST" style="margin-top: 20px; max-width: 400px;">
                    <input type="hidden" name="action" value="change_creds">
                    <div class="form-group">
                        <label>New Username</label>
                        <input type="text" name="new_username" required>
                    </div>
                    <div class="form-group">
                        <label>New Password</label>
                        <input type="password" name="new_password" required>
                    </div>
                    <button type="submit" class="secondary-btn">Update Credentials</button>
                </form>
            </details>
        </div>
    </div>
</body>
</html>
